package com.elitescloud.cloudt.comm.component.controller;

import com.elitescloud.cloudt.comm.component.service.ComComponentService;
import com.elitescloud.cloudt.comm.component.vo.ComPaymentTermSelectVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 公共下拉组件
 *
 * @author Chris
 * 2021-03-26
 */
@RestController
@RequestMapping("/com/component")
@RequiredArgsConstructor
@Api(value = "公共域-公共组件接口", tags = {"【过渡】公共域-公共组件接口"})
public class ComComponentController {

    private final ComComponentService comComponentService;

    /**
     * 获取全部支付条款
     *
     * @param codeName 编号或名称
     * @return 支付条款列表
     */
    @GetMapping("/paymentTerm/list")
    @ApiOperation("获取全部支付条款")
    public ApiResult<List<ComPaymentTermSelectVO>> paymentTermSelect(@RequestParam(required = false) @ApiParam("编号/名称，支持模糊查询") String codeName) {
        return ApiResult.ok(comComponentService.selectPaymentTerm(codeName));
    }

}
