package com.elitescloud.cloudt.comm.component.repo;

import com.elitescloud.cloudt.comm.component.vo.ComPaymentTermSelectVO;
import com.elitescloud.cloudt.comm.entity.QComPaymentTermDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author Chris
 * 2021-06-02
 */
@Component
@RequiredArgsConstructor
public class ComComponentRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QComPaymentTermDO comPaymentTermDO = QComPaymentTermDO.comPaymentTermDO;

    /**
     * 支付条款列表 - 下拉组件
     *
     * @param codeName 编号/名称 模糊查询
     * @return 列表
     */
    public List<ComPaymentTermSelectVO> selectPaymentTerm(String codeName) {
        var query = jpaQueryFactory
                .select(Projections.bean(
                        ComPaymentTermSelectVO.class,
                        comPaymentTermDO.id,
                        comPaymentTermDO.ptCode,
                        comPaymentTermDO.ptName,
                        comPaymentTermDO.days,
                        comPaymentTermDO.baseDayType,
                        comPaymentTermDO.dayCalcMethod
                ))
                .from(comPaymentTermDO);

        if (StringUtils.isNotBlank(codeName)) {
            var likeStr = "%" + codeName + "%";
            query.where(comPaymentTermDO.ptCode.like(likeStr).or(comPaymentTermDO.ptName.like(likeStr)));
        }
//        query.where(comPaymentTermDO.enableFlag.eq(1));
        query.where(comPaymentTermDO.deleteFlag.isNull().or(comPaymentTermDO.deleteFlag.eq(0)));

        return query.fetch();
    }
}
