package com.elitescloud.cloudt.log.config;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.log.service.LogStashService;
import com.elitescloud.cloudt.log.service.impl.LogStashServiceFilebeat;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * 日志的自动化配置.
 *
 * @author Kaiser（wang shao）
 * 2021/08/01
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(prefix = "elitesland.logstash", name = "enabled", havingValue = "true")
@ConditionalOnClass({RestHighLevelClient.class})
@EnableConfigurationProperties(LogStashProperties.class)
@Import(SwaggerLogStashConfig.class)
public class LogStashAutoConfiguration {

    @Bean
    public LogStashService logStashService(LogStashProperties logStashProperties) {
        HttpHost[] httpHosts = Assert.notEmpty(logStashProperties.getElasticsearchUris(), "")
                .stream()
                .map(this::convertHttpHost).toArray(HttpHost[]::new);
        var restClient = RestClient.builder(httpHosts);
        return new LogStashServiceFilebeat(new RestHighLevelClient(restClient),
                Assert.notBlank(logStashProperties.getLogGroup(), "日志所在组为空"));
    }

    private HttpHost convertHttpHost(String url) {
        var array = url.split(":");
        var scheme = array[0];
        var ip = array[1].substring(2);
        var port = Integer.parseInt(array[2]);
        return new HttpHost(ip, port, scheme);
    }
}
