package com.elitescloud.cloudt.log.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * 日志相关配置.
 *
 * @author Kaiser（wang shao）
 * 2021/08/01
 */
@ConfigurationProperties(prefix = "elitesland.logstash")
public class LogStashProperties {

    /**
     * 是否启用
     */
    private boolean enabled = false;
    /**
     * 日志存储的es地址
     */
    private List<String> elasticsearchUris;
    /**
     * 日志所在组
     */
    private String logGroup;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getElasticsearchUris() {
        return elasticsearchUris;
    }

    public void setElasticsearchUris(List<String> elasticsearchUris) {
        this.elasticsearchUris = elasticsearchUris;
    }

    public String getLogGroup() {
        return logGroup;
    }

    public void setLogGroup(String logGroup) {
        this.logGroup = logGroup;
    }
}
