package com.elitescloud.cloudt.log.controller;

import com.elitescloud.boot.log.common.EventTrackingInterface;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.logInfo.tracking.EventTrackingLogLevelEnum;
import com.elitescloud.cloudt.log.model.vo.param.LogStashQueryParam;
import com.elitescloud.cloudt.log.model.vo.resp.LogStashRecordRespVO;
import com.elitescloud.cloudt.log.service.LogStashService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 系统日志.
 *
 * @author Kaiser（wang shao）
 * 2021/08/01
 */
@RestController
@RequestMapping(value = "/logStash")
@Api(tags = "系统日志")
public class LogStashController {

    @Autowired(required = false)
    private LogStashService logStashService;

    /**
     * 获取应用名称列表
     *
     * @param size 获取名称的最多数量，默认20
     * @param startTime 开始时间
     * @param endTime 截止时间
     * @return 应用名称列表
     */
    @GetMapping(value = "/appName")
    @ApiOperation(value = "获取应用名称列表")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "size", value = "获取名称的最多数量，默认20"),
            @ApiImplicitParam(name = "startTime", value = "开始时间"),
            @ApiImplicitParam(name = "endTime", value = "截止时间")
    })
    public ApiResult<List<String>> queryAppName(Integer size, LocalDateTime startTime, LocalDateTime endTime) {
        return logStashService.appNameList(size, startTime, endTime);
    }

    /**
     * 获取日志级别列表
     *
     * @return 日志级别列表
     */
    @GetMapping(value = "/logLevel")
    @ApiOperation(value = "获取日志级别列表")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<String>> queryLogLevel() {
        return logStashService.logLevelList();
    }

    /**
     * 搜索日志
     *
     * @param queryParam 查询参数
     * @return 日志列表
     */
    @PostMapping(value = "/search")
    @ApiOperation(value = "搜索日志")
    @ApiOperationSupport(order = 3)
    public ApiResult<PagingVO<LogStashRecordRespVO>> search(@RequestBody LogStashQueryParam queryParam) {
        return logStashService.search(queryParam);
    }

    @Autowired
    private EventTrackingInterface eventTrackingInterface;

    /**
     * 埋点日志采集
     * @param contest
     * @return
     * @ignore
     */
    @PostMapping(value = "/testEventTrackingLog")
    @ApiOperation(value = "埋点日志采集")
    @ApiOperationSupport(order = 4)
    public ApiResult<Object> testEventTrackingLog(@RequestBody String contest) {
        eventTrackingInterface.addEventTracking(
                EventTrackingLogLevelEnum.ERROR,
                "埋点日志采集ERROR{}", contest);
        eventTrackingInterface.addEventTracking(
                EventTrackingLogLevelEnum.INFO,
                "埋点日志采集INFO{}", contest);
        eventTrackingInterface.addEventTracking(
                EventTrackingLogLevelEnum.DEBUG,
                "埋点日志采集DEBUG{}", contest);
        return ApiResult.ok(contest);
    }

}
