package com.elitescloud.cloudt.log.model.document;

import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Field;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author James.Huang
 * @version 2022.1
 * @date 2023/6/28 11:09
 * @Description:
 */
@Data
public class OperationLogDocument {

    @Field(name = "id")
    private String id;
    //触发端
    @Field(name = "triggerTerminal")
    private String triggerTerminal;
    //系统模块
    @Field(name = "sysModel")
    private String sysModel;
    //操作类型
    @Field(name = "operationType")
    private String operationType;
    //操作用户
    @Field(name = "operationUser")
    private String operationUser;
    //请求地址
    @Field(name = "operationUrl")
    private String operationUrl;

    @Field(name = "@timestamp")
    private LocalDateTime timestamp;
    //操作时间
    @Field(name = "operationTime" ,pattern = "yyyy-MM-dd HH:mm:ss")
    private String operationTime;
    //操作IP
    @Field(name = "operationIp")
    private String operationIp;
    //操作状态
    @Field(name = "operationStatus")
    private String operationStatus;
    //请求参数
    @Field(name = "requestParam")
    private String requestParam;
    //返回参数
    @Field(name = "responseParam")
    private String responseParam;
    //uuid,后续埋点日志使用
    @Field(name = "logId")
    private String logId;
    //请求方式
    @Field(name = "requestMethod")
    private String requestMethod;
    //异常描述
    @Field(name = "exceptionDesc")
    private String exceptionDesc;

    private LocalDateTime operationDateTime;

    public LocalDateTime getOperationDateTime() {
        if(operationTime!=null){

            if(operationTime.length()>19){
                operationTime=operationTime.substring(0,19);
            }

            DateTimeFormatter pattern=DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            try{
                operationDateTime=LocalDateTime.parse(operationTime,pattern);
            }catch (Exception e){
                e.printStackTrace();
            }

        }

        return operationDateTime;
    }

}
