package com.elitescloud.cloudt.log.model.vo.resp;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author James.Huang
 * @version 2022.1
 * @date 2023/6/25 14:05
 * @Description:
 */
@Data
@ApiModel(description = "操作日志分页数据")
public class OperationLogPageRespVO  implements Serializable {
    private static final long serialVersionUID = -452568360481668838L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private String id;

    @ApiModelProperty(value = "触发端", position = 2)
    private String triggerTerminal;

    @ApiModelProperty(value = "系统版块", position = 3)
    private String sysModel;

    @ApiModelProperty(value = "操作类型", position = 4)
    private String operationType;

    @ApiModelProperty(value = "操作用户", position = 5)
    private String operationUser;

    @ApiModelProperty(value = "请求地址", position = 6)
    private String operationUrl;

    @ApiModelProperty(value = "操作时间", position = 7)
    private String operationTime;

    @ApiModelProperty(value = "操作IP", position = 8)
    private String operationIp;

    @ApiModelProperty(value = "操作状态", position = 9)
    private String operationStatus;

    @ApiModelProperty(value = "请求参数", position = 10)
    private String requestParam;
    @ApiModelProperty(value = "返回参数", position = 11)
    private String responseParam;
    //uuid,后续埋点日志使用
    @ApiModelProperty(value = "日志ID", position = 12)
    private String logId;
    //请求方式
    @ApiModelProperty(value = "操作方式", position = 13)
    private String requestMethod;

    @ApiModelProperty(value = "异常描述", position = 14)
    private String exceptionDesc;

    @ApiModelProperty(value = "操作时间-显示使用", position = 15)
    private LocalDateTime operationDateTime;
}
