package com.elitescloud.cloudt.spi.test.instances;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.system.spi.test.UserMngSpiTest;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 默认实例.
 *
 * @author Kaiser（wang shao）
 * 2022/11/11
 */
@Log4j2
@Order(value = Ordered.HIGHEST_PRECEDENCE)
public class DefaultUserMngSpiTestInstance implements UserMngSpiTest {

    @Autowired(required = false)
    private RedisUtils redisUtils;

    @Override
    public void onUserCreate(String username) {
        log.info("默认实例：{}", username);
        log.info("redis：" + redisUtils != null);
    }
}
