package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.boot.auth.cas.provider.ThirdPartyAccountTransferHelper;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 统一身份认证配置.
 *
 * @author Kaiser（wang shao）
 * 2022/12/3
 */
@Configuration(proxyBeanMethods = false)
class SystemCasConfig {

    @Configuration(proxyBeanMethods = false)
    @ConditionalOnProperty(prefix = AuthorizationSdkProperties.CONFIG_PREFIX + ".cas-client", name = "enabled", havingValue = "true")
    static class CasProviderConfig {
        private final AuthorizationSdkProperties sdkProperties;

        public CasProviderConfig(AuthorizationSdkProperties sdkProperties) {
            this.sdkProperties = sdkProperties;
        }

        @Bean
        public UserSourceProvider sourceProvider() {
            return new SystemUserSyncProvider();
        }

        @Bean
        public UserTransferHelper userTransferHelper() {
            return UserTransferHelper.getInstance(sdkProperties.getAuthServer());
        }

        @Bean
        public UserChangedCallbackCas userChangedCallbackCas(UserTransferHelper userTransferHelper) {
            return new UserChangedCallbackCas(sdkProperties, userTransferHelper);
        }

        @Bean
        public ThirdPartyAccountTransferHelper thirdPartyAccountTransferHelper() {
            return ThirdPartyAccountTransferHelper.getInstance(sdkProperties.getAuthServer());
        }

        @Bean
        public ThirdPartyAccountChangedCallbackCas thirdPartyAccountChangedCallbackCas(ThirdPartyAccountTransferHelper transferHelper) {
            return new ThirdPartyAccountChangedCallbackCas(transferHelper);
        }

        @Bean
        public PwdStrategyTransferHelper pwdStrategyTransferHelper() {
            return PwdStrategyTransferHelper.getInstance(sdkProperties.getAuthServer());
        }
    }

    @Configuration(proxyBeanMethods = false)
    @ConditionalOnClass({UserDetailManager.class})
    static class AuthProviderConfig {
        private final AuthorizationProperties authorizationProperties;

        public AuthProviderConfig(AuthorizationProperties authorizationProperties) {
            this.authorizationProperties = authorizationProperties;
        }

        @SuppressWarnings({"deprecation", "removal"})
        @Bean
        public UserDetailManager userDetailManagerSystemSelf(ISysUserService sysUserService) {
            return new SystemUserDetailManager(authorizationProperties, sysUserService);
        }
    }
}
