package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.system.service.IUserService;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用户同步任务服务提供者.
 *
 * @author Kaiser（wang shao）
 * 2022/12/3
 */
@Log4j2
class SystemUserSyncProvider extends BaseCasClientService implements UserSourceProvider {
    @Autowired
    private UserRepoProc userRepoProc;

    @Autowired
    private IUserService userService;

    @Override
    public List<AuthUserDTO> queryUserList(int size) {
        return userRepoProc.queryToSyncCas(size).stream()
                .map(super::do2Dto)
                .collect(Collectors.toList());
    }

    @Override
    public void successCallback(Map<String, Long> userMap) {
        userService.updateCasSyncResult(userMap);
    }
}
