package com.elitescloud.cloudt.system.config;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.system.service.SysVersionService;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import com.elitescloud.cloudt.system.service.model.BaseStdTreeModel;
import org.springframework.stereotype.Component;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/28
 */
@Component
public class SystemAuditCustomizer implements AuditCustomizer {

    private final SystemProperties.StdProject prop;
    private final SysVersionService versionService;

    public SystemAuditCustomizer(SystemProperties properties, SysVersionService versionService) {
        this.prop = properties.getStdProject();
        this.versionService = versionService;
    }

    @Override
    public void onCreate(Object source) {
        if (!needRecordStd()) {
            return;
        }

        if (source instanceof BaseStdModel) {
            BaseStdModel model = (BaseStdModel) source;
            model.setStdProduct(true);
            model.setStdVersion(this.obtainCurrentVersion());
            return;
        }
        if (source instanceof BaseStdTreeModel) {
            BaseStdTreeModel model = (BaseStdTreeModel) source;
            model.setStdProduct(true);
            model.setStdVersion(this.obtainCurrentVersion());
        }
    }

    @Override
    public void onUpdate(Object source) {
        // ignored
    }

    private boolean needRecordStd() {
        if (!Boolean.TRUE.equals(prop.getEnabled())) {
            // 非标产项目
            return false;
        }
        var currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return false;
        }

        // 超级管理员，需要
        if (InnerUserEnum.ADMIN.getUsername().equals(currentUser.getUsername())) {
            return true;
        }

        // 云时通租户，需要
        var tenant = currentUser.getTenant();
        if (tenant != null && tenant.getTenantCode().equals(prop.getTenantCode())) {
            return true;
        }

        return false;
    }

    private String obtainCurrentVersion() {
        return versionService.findActiveVersion().getData();
    }
}
