package com.elitescloud.cloudt.system.config;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.constant.AccountType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 系统配置属性.
 *
 * @author Kaiser（wang shao）
 * 2022/7/6
 */
@ConfigurationProperties(prefix = SystemProperties.CONFIG_PREFIX)
public class SystemProperties {

    public static final String CONFIG_PREFIX = "elitesland.project.system";

    /**
     * 登录账号是否可修改
     */
    private Boolean usernameEditable = false;

    /**
     * 组织编号是否可变更
     */
    private Boolean orgCodeEditable = false;

    /**
     * 是否限制手机号唯一
     */
    private Boolean mobileUnique = true;

    /**
     * 是否限制邮箱唯一
     */
    private Boolean emailUnique = true;

    /**
     * 是否限制证件号唯一
     */
    private Boolean idCardUnique = true;

    /**
     * 账号类型
     */
    private List<AccountType> accountTypes = new ArrayList<>(4);

    /**
     * 权限配置冲突时是否显示
     */
    private Boolean permissionConflictShow = true;

    /**
     * 是否限制组织树只能有一个
     */
    private Boolean limitOrgTreeOne = true;

    /**
     * 是否使用公司类型的组织作为ou
     */
    private Boolean useCompanyOrgAsOu = true;

    private String esAddress;

    /**
     * 三方接口日志
     */
    @NestedConfigurationProperty
    private ThirdApiLog thirdApiLog = new ThirdApiLog();

    /**
     * 标产版本
     */
    @NestedConfigurationProperty
    private StdProject stdProject = new StdProject();

    public Boolean getUsernameEditable() {
        return usernameEditable;
    }

    public void setUsernameEditable(Boolean usernameEditable) {
        this.usernameEditable = usernameEditable;
    }

    public Boolean getOrgCodeEditable() {
        return orgCodeEditable;
    }

    public void setOrgCodeEditable(Boolean orgCodeEditable) {
        this.orgCodeEditable = orgCodeEditable;
    }

    public Boolean getMobileUnique() {
        return mobileUnique;
    }

    public void setMobileUnique(Boolean mobileUnique) {
        this.mobileUnique = mobileUnique;
    }

    public Boolean getEmailUnique() {
        return emailUnique;
    }

    public void setEmailUnique(Boolean emailUnique) {
        this.emailUnique = emailUnique;
    }

    public Boolean getIdCardUnique() {
        return idCardUnique;
    }

    public void setIdCardUnique(Boolean idCardUnique) {
        this.idCardUnique = idCardUnique;
    }

    public List<AccountType> getAccountTypes() {
        return accountTypes;
    }

    public void setAccountTypes(List<AccountType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public Boolean getPermissionConflictShow() {
        return permissionConflictShow;
    }

    public void setPermissionConflictShow(Boolean permissionConflictShow) {
        this.permissionConflictShow = permissionConflictShow;
    }

    public String getEsAddress() {
        return esAddress;
    }

    public void setEsAddress(String esAddress) {
        this.esAddress = esAddress;
    }

    public Boolean getLimitOrgTreeOne() {
        return limitOrgTreeOne;
    }

    public void setLimitOrgTreeOne(Boolean limitOrgTreeOne) {
        this.limitOrgTreeOne = limitOrgTreeOne;
    }

    public Boolean getUseCompanyOrgAsOu() {
        return useCompanyOrgAsOu;
    }

    public void setUseCompanyOrgAsOu(Boolean useCompanyOrgAsOu) {
        this.useCompanyOrgAsOu = useCompanyOrgAsOu;
    }

    public ThirdApiLog getThirdApiLog() {
        return thirdApiLog;
    }

    public void setThirdApiLog(ThirdApiLog thirdApiLog) {
        this.thirdApiLog = thirdApiLog;
    }

    public StdProject getStdProject() {
        return stdProject;
    }

    public void setStdProject(StdProject stdProject) {
        this.stdProject = stdProject;
    }

    public static class ThirdApiLog {
        /**
         * 是否启用重试
         */
        private Boolean enabledRetry = false;

        /**
         * 重试次数
         */
        private Integer retryTimes = 3;

        /**
         * 重试间隔
         */
        private List<Duration> retryIntervals = List.of(Duration.ofMinutes(10), Duration.ofMinutes(20), Duration.ofMinutes(30));

        /**
         * 业务类型
         */
        private List<CodeNameParam> businessTypes = new ArrayList<>();

        /**
         * 源系统
         */
        private List<CodeNameParam> sourceSystems = new ArrayList<>();

        /**
         * 目标系统
         */
        private List<CodeNameParam> targetSystems = new ArrayList<>();

        public Boolean getEnabledRetry() {
            return enabledRetry;
        }

        public void setEnabledRetry(Boolean enabledRetry) {
            this.enabledRetry = enabledRetry;
        }

        public Integer getRetryTimes() {
            return retryTimes;
        }

        public void setRetryTimes(Integer retryTimes) {
            this.retryTimes = retryTimes;
        }

        public List<Duration> getRetryIntervals() {
            return retryIntervals;
        }

        public void setRetryIntervals(List<Duration> retryIntervals) {
            this.retryIntervals = retryIntervals;
        }

        public List<CodeNameParam> getBusinessTypes() {
            return businessTypes;
        }

        public void setBusinessTypes(List<CodeNameParam> businessTypes) {
            this.businessTypes = businessTypes;
        }

        public List<CodeNameParam> getSourceSystems() {
            return sourceSystems;
        }

        public void setSourceSystems(List<CodeNameParam> sourceSystems) {
            this.sourceSystems = sourceSystems;
        }

        public List<CodeNameParam> getTargetSystems() {
            return targetSystems;
        }

        public void setTargetSystems(List<CodeNameParam> targetSystems) {
            this.targetSystems = targetSystems;
        }
    }

    public static class StdProject {
        /**
         * 是否标产
         */
        private Boolean enabled = false;
        /**
         * 租户编码
         */
        private String tenantCode = "";

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getTenantCode() {
            return tenantCode;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }
    }
}
