package com.elitescloud.cloudt.system.config.support;

import com.elitescloud.boot.mq.common.MessageRetryProvider;
import com.elitescloud.boot.mq.common.model.RetryMessageDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqSendResultDTO;
import com.elitescloud.cloudt.system.service.SysMqMessageMngService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/30
 */
@Slf4j
@Component
@ConditionalOnClass(value = {com.elitescloud.boot.mq.common.MessageRetryProvider.class})
public class SystemMqMessageRetryProvider implements MessageRetryProvider {

    @Autowired
    private SysMqMessageMngService messageMngService;

    @Override
    public List<RetryMessageDTO> queryTask(String lastMessageId, int size) {
        var msgRes = messageMngService.queryRetryMessage(lastMessageId, size);
        if (msgRes.isFailed()) {
            log.error("查询待重试消息异常：{}", msgRes.getMsg());
        }
        return msgRes.getData();
    }

    @Override
    public void deleteTask(@NotBlank String messageId, String reason) {
        log.info("删除重试消息：{}, {}", messageId, reason);
        var res = messageMngService.deleteRetryMessage(messageId, reason);
        log.info("删除重试消息结果：{}，{}", messageId, res.getMsg());
    }

    @Override
    public boolean trySend(@NotBlank String messageId, Integer version) {
        var res = messageMngService.trySend(messageId, version);
        log.info("消息是否可发送：{}，{}，{}", messageId, res.getData(), res.getMsg());
        if (res.isSuccess()) {
            return Boolean.TRUE.equals(res.getData());
        }
        return true;
    }

    @Override
    public void updateRetryResult(@NotBlank String messageId, boolean success, String reason) {
        log.info("更新消息重试结果：{}，{}，{}", messageId, success, reason);

        SysMqSendResultDTO sysMqSendResultDTO = new SysMqSendResultDTO();
        sysMqSendResultDTO.setMessageId(messageId);
        sysMqSendResultDTO.setSuccess(success);
        sysMqSendResultDTO.setFailReason(reason);

        messageMngService.updateSendResult(sysMqSendResultDTO);
    }
}
