package com.elitescloud.cloudt.system.controller.common.system;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.PlatformQueryService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 平台通用接口.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/23
 */
@Api(tags = "平台通用接口")
@RestController
@RequestMapping(value = "/common/platform", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_VERSION)
public class PlatformCommonController {

    private PlatformQueryService platformQueryService;

    @ApiOperation(value = "版本列表")
    @ApiOperationSupport(order = 1)
    @GetMapping(value = "/versions")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,
            operationDescription = "版本列表")
    public ApiResult<List<CodeNameParam>> getVersionList() {
        return platformQueryService.listProjectVersion();
    }

    @Autowired
    public void setPlatformQueryService(PlatformQueryService platformQueryService) {
        this.platformQueryService = platformQueryService;
    }
}
