package com.elitescloud.cloudt.system.controller.common.user;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.save.index.ModifyPasswordSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.index.PasswordUpdateSaveVO;
import com.elitescloud.cloudt.system.service.IndexUserService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Set;

/**
 * 用户通用接口.
 *
 * @author Kaiser（wang shao）
 * 2022/12/13
 */
@Api(tags = "用户通用接口")
@RestController
@RequestMapping(value = "/common/user", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class UserCommonController {
    static {
        // 修改密码
        InterceptUri.addAllowUri(Set.of("/common/user/retrievePwd/sendCode", "/common/user/retrievePwd/verifyCode"));
    }

    private final IndexUserService indexUserService;

    public UserCommonController(IndexUserService indexUserService) {
        this.indexUserService = indexUserService;
    }

    /**
     * 获取当前用户信息
     *
     * @return 当前用户
     */
    @ApiOperation(value = "获取当前用户信息")
    @ApiOperationSupport(order = 1)
    @GetMapping(value = "/currentUser")
    public ApiResult<SysUserDTO> currentUser() {
        var currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        currentUser.getUser().setPassword(null);
        return ApiResult.ok(currentUser.getUser());
    }

    /**
     * 修改当前用户密码
     *
     * @param saveVO 保存信息
     * @return 修改结果
     */
    @ApiOperation(value = "修改当前用户密码【通过老密码】")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/update/currentPwd")
    public ApiResult<Boolean> updatePassword(@RequestBody ModifyPasswordSaveVO saveVO) {
        return indexUserService.updatePassword(saveVO);
    }

    @ApiOperation(value = "【修改密码】修改密码的发送验证码")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/updatePwd/sendCode")
    public ApiResult<String> sendVerifyCodeForUpdatePwd(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeParam) {
        return indexUserService.sendVerifyCodeForUpdatePwd(false, verifyCodeParam);
    }

    @ApiOperation(value = "【修改密码】根据验证码修改密码")
    @ApiOperationSupport(order = 4)
    @PutMapping(value = "/updatePwd/verifyCode")
    public ApiResult<Long> updatePwd(@RequestBody @Valid PasswordUpdateSaveVO saveVO) {
        return indexUserService.updatePwdByVerifyCode(false, saveVO);
    }

    @ApiOperation(value = "【找回密码】找回密码的发送验证码")
    @ApiOperationSupport(order = 5)
    @PostMapping(value = "/retrievePwd/sendCode")
    public ApiResult<String> sendVerifyCodeForRetrievePwd(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeParam) {
        return indexUserService.sendVerifyCodeForUpdatePwd(true, verifyCodeParam);
    }

    @ApiOperation(value = "【找回密码】根据验证码修改密码")
    @ApiOperationSupport(order = 6)
    @PutMapping(value = "/retrievePwd/verifyCode")
    public ApiResult<Long> retrievePwd(@RequestBody @Valid PasswordUpdateSaveVO saveVO) {
        return indexUserService.updatePwdByVerifyCode(true, saveVO);
    }
}
