package com.elitescloud.cloudt.system.controller.devops;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.save.devops.ExportBasicDataSaveVO;
import com.elitescloud.cloudt.system.service.SystemDataService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;

/**
 * 系统初始化.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
@Api(tags = "运维工具")
@RestController
@RequestMapping(value = "/devops/init", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
public class SystemInitController {

    private final SystemDataService service;

    public SystemInitController(SystemDataService service) {
        this.service = service;
    }

    @ApiOperation(value = "导出初始化数据")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/export/data")
    public ApiResult<Long> exportData(@RequestBody ExportBasicDataSaveVO saveVO) {
        return service.exportData(saveVO);
    }

    @ApiOperation(value = "导入初始化数据")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "file", value = "数据文件", required = true),
            @ApiImplicitParam(name = "incremental", value = "是否增量更新", example = "true"),
    })
    @PostMapping(value = "/import/data")
    public ApiResult<Boolean> importData(@RequestParam(name = "file") @NotNull(message = "请选择文件") MultipartFile file,
                                         @RequestParam(name = "incremental", defaultValue = "true") Boolean incremental) {
        return service.importData(file, incremental);
    }
}
