package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@Api(tags = "通用权限接口")
@RestController
@RequestMapping(value = "/mng/common/permission", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class CommonPermissionController {

    private RoleQueryService roleQueryService;

    @GetMapping(value = "/roles")
    @ApiOperation(value = "查询角色列表")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "businessKey", value = "业务标识，[UDC]cloudt-system:roleBusiness"),
            @ApiImplicitParam(name = "roleName", value = "角色名称"),
    })
    public ApiResult<List<IdCodeNameParam>> queryRoleList(@RequestParam(name = "businessKey", required = false) String businessKey,
                                                        @RequestParam(name = "roleName", required = false) String roleName) {
        return roleQueryService.listRole(businessKey, roleName);
    }

    @GetMapping(value = "/roleGroups")
    @ApiOperation(value = "查询角色分组列表")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<IdCodeNameParam>> queryRoleGroupList() {
        return roleQueryService.listAllRoleGroup();
    }

    @Autowired
    public void setRoleQueryService(RoleQueryService roleQueryService) {
        this.roleQueryService = roleQueryService;
    }
}
