package com.elitescloud.cloudt.system.controller.mng.dpr;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.jpa.strategy.RoleRuleJpaService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.query.dpr.EmployeePagedRespParam;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.List;
import java.util.Map;

/**
 * 员工管理数据权限API接口
 *
 * @author niuchen
 * 2023/1/28
 */
@Api(tags = "【调试】员工管理数据权限API接口-实例接口")
@RestController
@RequestMapping(value = "/mng/employee/searcher", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class EmployeeMngSearcherController {

    private final EmployeeMngService employeeMngService;
    private final BeanSearcherFactory beanSearcherFactory;
    private BeanSearcher beanSearcher;

    private MapSearcher mapSearcher;

    private final RoleDataPermissionRuleService roleDataPermissionRuleService;

    public EmployeeMngSearcherController(EmployeeMngService employeeMngService,
                                         BeanSearcherFactory beanSearcherFactory,
                                         RoleDataPermissionRuleService roleDataPermissionRuleService,
                                         EmployeeRepo employeeRepo,
                                         JPAQueryFactory jpaQueryFactory,
                                         RoleRuleJpaService roleService) {
        this.employeeMngService = employeeMngService;
        this.beanSearcherFactory = beanSearcherFactory;
        this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT_AUTH);
        this.mapSearcher = beanSearcherFactory.getMapBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT_AUTH);
        this.roleDataPermissionRuleService = roleDataPermissionRuleService;
        this.employeeRepo = employeeRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.roleService = roleService;

    }

    /**
     * 分页查询员工
     * ApiResult<PagingVO<EmployeePagedRespVO>>
     *
     * @param params 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "返回当前用户的数据权限集合")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/getUserRoleDpr")
    public ApiResult getUserRoleDpr(
            @RequestBody Map<String, Object> params) {
        var obj = roleDataPermissionRuleService.getUserRoleDpr();
        return ApiResult.ok(obj);
    }

    /**
     * 分页查询员工
     * ApiResult<PagingVO<EmployeePagedRespVO>>
     *
     * @param params 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询员工，按照租户查询")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page2")
    public ApiResult<SearchResult<EmployeePagedRespBean>> page(
            @RequestBody Map<String, Object> params) {
        var obj = beanSearcher.search(EmployeePagedRespBean.class, params);
        return ApiResult.ok(obj);
    }
    /**
     * 分页查询员工
     * ApiResult<PagingVO<EmployeePagedRespVO>>
     *
     * @param params 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询员工，按照租户查询")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    public ApiResult<SearchResult<Map<String, Object>>> mapPage(
            @RequestBody Map<String, Object> params) {
         var obj = mapSearcher.search(EmployeePagedRespBean.class, params);
        return ApiResult.ok(obj);
    }


    @ApiOperation(value = "分页查询员工，按照租户查询 EmployeePagedRespParam")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/paramPage")
    public ApiResult<SearchResult<Map<String, Object>>> paramPage(
            @RequestBody EmployeePagedRespParam params) {
        var wereSqlMapBuilder = MapUtils.builder()
                .page(params.getCurrent(), params.getSize())
                .field(EmployeePagedRespBean::getCode, params.getCode()).op(FieldOps.Contain)
                .field(EmployeePagedRespBean::getServed, params.getServed()).op(FieldOps.Equal)
                .orderBy("id").desc();

        var obj = mapSearcher.search(EmployeePagedRespBean.class, wereSqlMapBuilder.build());
        return ApiResult.ok(obj);
    }

    @ApiOperation(value = " 查询员工")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page/{userId}")
    public ApiResult<SearchResult<EmployeePagedRespBean>> getById(
            @PathVariable Long userId) {
        var wereSqlMapBuilder = MapUtils.builder()
                .field(EmployeePagedRespBean::getUserId,userId).op(FieldOps.Equal);

        var obj = beanSearcher.search(EmployeePagedRespBean.class, wereSqlMapBuilder.build());

        return ApiResult.ok(obj);
    }

     private final EmployeeRepo employeeRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final   RoleRuleJpaService roleService;
//    private final EntityManager entityManager;
    @ApiOperation(value = " 查询员工getJpaParamPage")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/jpa/paramPage")
    public ApiResult<List<SysEmployeeDO>> getJpaParamPage() {
       QSysEmployeeDO QDO = QSysEmployeeDO.sysEmployeeDO;
        Predicate authWhere= roleService.getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(SysEmployeeDO.class);

//        Predicate authWhere2= roleService.
//                getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(
//                        SysEmployeeDO.class,"sysEmployeeDO","username");
//
//       //组1
//        Predicate where= QDO.username.eq("email")
//                .and(QDO.userId.eq(222L));
//            //or
//        //组2
//        Predicate where2= QDO.rootOrgId.in(1,2,3,4)
//                .and(QDO.secUserId.eq(2232L));
//         jpaQueryFactory.select(QDO)
//                .from(QDO)
//                .where(authWhere)
//                .limit(1).fetch();
//
//
//        Predicate utils1= ExpressionUtils.anyOf(QDO.username.eq("email"), QDO.userId.eq(222L));
//        Predicate utils2= ExpressionUtils.anyOf(QDO.secUserId.eq(2232L));
//        var util3=ExpressionUtils.or(utils1,utils2);
//         jpaQueryFactory.select(QDO)
//                .from(QDO)
//                .where(util3)
//                .limit(1).fetch();
////        and (
////                (sysemploye0_.username='email'
////                and sysemploye0_.user_id=222)
////                or
////                        ((sysemploye0_.root_org_id in (1 , 2 , 3 , 4))
////                and sysemploye0_.sec_user_id=2232)
////            )
//        System.out.println("------------");
//       var var1=  QDO.username.eq("email").and(QDO.userId.eq(223L));
//        var var2=  QDO.username.eq("email").and(QDO.userId.eq(223L));
//        var var3=ExpressionUtils.predicate(Ops.OR,var1,var2);
//
//        BooleanBuilder whereClause = new BooleanBuilder();
//        BooleanExpression p1 = QDO.username.eq("email"); // 第一个条件
//        BooleanExpression p2 = QDO.userId.eq(223L); // 第二个条件
//        BooleanExpression p3 = QDO.username.eq("email"); // 第一个条件
//        BooleanExpression p4 = QDO.userId.eq(223L); // 第二个条件
//        // 添加括号表达式
//        whereClause.and(
//                new BooleanBuilder().or(p1.and(p2)).or(p3.and(p4))
//        );
//
//          var1=Expressions.booleanTemplate("(({0} = 223 and {0} = 223) or ({1}=222 and {1}=222))", QDO.userId,QDO.username);
//
//        jpaQueryFactory.select(QDO)
//                .from(QDO)
//                .where(whereClause)
//                .limit(1).fetch();
//        System.out.println("------------");
//        BooleanBuilder groupPredicate = new BooleanBuilder();
//        groupPredicate.and( new BooleanBuilder(where).or(where2)) ;
//        jpaQueryFactory.select(QDO)
//                .from(QDO)
//                .where(groupPredicate)
//                .limit(1).fetch();
//
//
//// 创建第一组条件：root_org_id in (1, 2, 3, 4) AND sec_user_id = 745272818224078679
//        BooleanBuilder conditionGroup1 = new BooleanBuilder();
//        conditionGroup1.and(QDO.rootOrgId.in(1, 2, 3, 4))
//                .and(QDO.secUserId.eq(745272818224078679L));
//   //OR
//// 创建第二组条件：username = 'username' AND user_id = 1
//        BooleanBuilder conditionGroup2 = new BooleanBuilder();
//        conditionGroup2.and(QDO.username.eq("username")).and(QDO.userId.eq(1L))
//                 ;
//
//        BooleanBuilder finalCondition = conditionGroup1.or(conditionGroup2);
//        BooleanBuilder conditionGroup3= new BooleanBuilder();
//        conditionGroup3.and(conditionGroup1).or(conditionGroup2);
////       var and= groupPredicate.andAnyOf(where,where2);
//         var data= jpaQueryFactory.select(QDO)
//                .from(QDO)
//                .where(conditionGroup1).where(conditionGroup2)
//                .limit(1).fetch();

        return ApiResult.ok(null);
    }


}
