package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.save.extend.FrontTableCfgSaveVO;
import com.elitescloud.cloudt.system.service.FrontTableCfgService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

/**
 * 前端表格配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/20
 */
@Api(tags = "前端表格配置")
@RestController
@RequestMapping(value = "/mng/frontTable/cfg", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_FRONT_TABLE_CFG)
public class FrontTableCfgController {
    private FrontTableCfgService service;

    /**
     * 保存用户配置
     *
     * @param saveVO 配置信息
     * @return 保存结果
     */
    @ApiOperation(value = "保存用户配置")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/save/user")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE,operationDescription = "保存用户配置"
            ,logEnabled = true,resultJsonEnabled = true,argsJsonEnabled = true)
    public ApiResult<Boolean> saveUserConfig(@RequestBody @Valid FrontTableCfgSaveVO saveVO) {
        return service.saveCfg(saveVO, false);
    }

    /**
     * 获取用户配置
     *
     * @param tableCode 表格编码
     * @return 配置内容
     */
    @ApiOperation(value = "获取用户配置")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "tableCode", value = "表格编码", required = true, paramType = "query")
    @GetMapping(value = "/get/user")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,operationDescription = "获取用户配置"
            )
    public ApiResult<String> getUserConfig(@RequestParam("tableCode") @NotBlank(message = "tableCode") String tableCode) {
        return service.getCfg(tableCode, false);
    }

    /**
     * 保存全局配置
     *
     * @param saveVO 配置信息
     * @return 保存结果
     */
    @ApiOperation(value = "保存全局配置")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/save/global")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE, operationDescription = "保存全局配置"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Boolean> saveGlobalConfig(@RequestBody @Valid FrontTableCfgSaveVO saveVO) {
        return service.saveCfg(saveVO, true);
    }

    /**
     * 获取全局配置
     *
     * @param tableCode 表格编码
     * @return 配置内容
     */
    @ApiOperation(value = "获取全局配置")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "tableCode", value = "表格编码", required = true, paramType = "query")
    @GetMapping(value = "/get/global")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,operationDescription = "获取全局配置"
            )
    public ApiResult<String> getGlobalConfig(@RequestParam("tableCode") @NotBlank(message = "tableCode") String tableCode) {
        return service.getCfg(tableCode, true);
    }

    @Autowired
    public void setService(FrontTableCfgService service) {
        this.service = service;
    }
}
