package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TaxRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TaxRateDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TaxRatePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TaxRateSaveVO;
import com.elitescloud.cloudt.system.service.TaxRateMngService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

/**
 * 税率管理.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Api(tags = "税率管理")
@RestController
@RequestMapping(value = "/mng/taxRate", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_TAX_RATE)
public class TaxRateController {

    private final TaxRateMngService service;

    public TaxRateController(TaxRateMngService service) {
        this.service = service;
;
    }



    /**
     * 分页查询税率
     *
     * @param queryVO 查询参数
     * @return 税率列表
     */
    @PostMapping(value = "/q")
    @ApiOperation(value = "分页查询税率")
    @ApiOperationSupport(order = 1)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE,operationDescription = "分页查询税率"
           )
    public ApiResult<PagingVO<TaxRatePageRespVO>> page(@RequestBody TaxRatePageQueryVO queryVO) {
       var o= service.page(queryVO);
        var list=o.getData().getRecords();
        for(TaxRatePageRespVO vo:list){
            vo.setTaxRateValue2(generateRandomBigDecimal(8));
            vo.setCeshi(12334);
        }
        return  o;
    }
    public static BigDecimal generateRandomBigDecimal(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Scale must be a non-negative integer");
        }

        Random random = new Random();
        // Generate a random double value between 0 and 1
        double randomValue = random.nextDouble();

        // Create a BigDecimal from the random double value with the specified scale
        BigDecimal result = new BigDecimal(randomValue).setScale(scale, RoundingMode.HALF_UP);

        return result;
    }
    /**
     * 切换启用禁用
     *
     * @param id 税率ID
     * @return 切换结果
     */
    @PatchMapping(value = "/switch/{id}/enabled")
    @ApiOperation(value = "切换启用禁用")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "税率ID", required = true)
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE,operationDescription = "切换启用禁用"
            ,logEnabled = true,resultJsonEnabled = true,argsJsonEnabled = true)
    public ApiResult<Long> switchEnabled(@PathVariable("id") Long id) {
        return service.updateEnabled(id);
    }

    /**
     * 获取税率详情
     *
     * @param id 税率ID
     * @return 税率详情
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "获取税率详情")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "税率ID", required = true)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,operationDescription = "获取税率详情"
        )
    public ApiResult<TaxRateDetailRespVO> get(@PathVariable("id") Long id) {
        return service.get(id);
    }

    /**
     * 保存税率
     *
     * @param saveVO 税率信息
     * @return 税率ID
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "保存税率")
    @ApiOperationSupport(order = 4)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE,operationDescription = "保存税率"
            ,logEnabled = true,resultJsonEnabled = true,argsJsonEnabled = true)
    public ApiResult<Long> save(@RequestBody @Valid TaxRateSaveVO saveVO) {
        return service.save(saveVO);
    }

    /**
     * 删除税率信息
     *
     * @param id 税率ID
     * @return 税率ID
     */
    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "删除税率信息")
    @ApiOperationSupport(order = 5)
    @ApiImplicitParam(name = "id", value = "税率ID", required = true)
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE,operationDescription = "删除税率信息"
            ,logEnabled = true,resultJsonEnabled = true,argsJsonEnabled = true)
    public ApiResult<Long> delete(@PathVariable("id") Long id) {
        return service.delete(id);
    }
}
