package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.ThirdApiLogSaveVO;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 三方接口日志.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/15
 */
@Api(tags = "三方接口日志")
@RestController
@RequestMapping(value = "/mng/thirdLog", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class ThirdApiLogController {

    private final ThirdApiLogService service;

    public ThirdApiLogController(ThirdApiLogService service) {
        this.service = service;
    }

    /**
     * 分页查询日志
     *
     * @param queryVO 查询参数
     * @return 日志列表
     */
    @ApiOperation(value = "分页查询日志列表")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> queryByPage(@RequestBody ThirdApiLogQueryVO queryVO) {
        return service.queryByPage(queryVO);
    }

    /**
     * 查询重试列表
     *
     * @param id 原始ID
     * @return 重试记录列表
     */
    @ApiOperation(value = "查询重试列表")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "日志记录ID", required = true)
    @GetMapping(value = "/listRetry")
    public ApiResult<List<ThirdApiLogPageRespVO>> listRetryRecord(@RequestParam(name = "id") @NotNull(message = "记录ID为空") Long id) {
        return service.listRetryRecord(id);
    }

    /**
     * 获取详细信息
     *
     * @param id 记录ID
     * @return 详细信息
     */
    @ApiOperation(value = "获取详细信息")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "日志记录ID", required = true)
    @GetMapping(value = "/detail")
    public ApiResult<ThirdApiLogDetailRespVO> getDetail(@RequestParam(name = "id") @NotNull(message = "记录ID为空") Long id) {
        return service.getDetail(id);
    }

    /**
     * 修改日志信息
     *
     * @param saveVO 查询参数
     * @param retry  是否重试
     * @return 日志ID
     */
    @ApiOperation(value = "修改日志信息")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "retry", value = "是否重试")
    @PostMapping(value = "/save")
    public ApiResult<Long> saveAndSend(@RequestBody @Valid ThirdApiLogSaveVO saveVO,
                                       @RequestParam(name = "retry", required = false, defaultValue = "false") Boolean retry) {
        return service.saveLog(saveVO, Boolean.TRUE.equals(retry));
    }

    /**
     * 获取所有的业务类型
     *
     * @return 业务类型列表
     */
    @ApiOperation(value = "获取所有的业务类型")
    @ApiOperationSupport(order = 11)
    @GetMapping(value = "/const/businessType")
    public ApiResult<List<CodeNameParam>> listBusinessTypes() {
        return service.listBusinessTypes();
    }

    /**
     * 获取所有的目标系统
     *
     * @return 业务类型列表
     */
    @ApiOperation(value = "获取所有的目标系统")
    @ApiOperationSupport(order = 12)
    @GetMapping(value = "/const/targetSystem")
    public ApiResult<List<CodeNameParam>> listTargetSystems() {
        return service.listTargetSystems();
    }

    /**
     * 获取所有的源系统
     *
     * @return 业务类型列表
     */
    @ApiOperation(value = "获取所有的源系统")
    @ApiOperationSupport(order = 13)
    @GetMapping(value = "/const/sourceSystem")
    public ApiResult<List<CodeNameParam>> listSourceSystems() {
        return service.listSourceSystems();
    }
}
