package com.elitescloud.cloudt.system.controller.mng.role;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RoleGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleGroupSaveVO;
import com.elitescloud.cloudt.system.service.RoleGroupMngService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 角色组管理.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/27
 */
@Api(tags = "角色组管理")
@RestController
@RequestMapping(value = "/mng/roleGroup", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_ROLE_GROUP)
public class RoleGroupMngController {

    private RoleGroupMngService service;

    /**
     * 保存角色组
     *
     * @param saveVO 角色组信息
     * @return 角色组ID
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "保存角色组")
    @ApiOperationSupport(order = 1)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE, operationDescription = "保存角色组"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Long> upsert(@Valid @RequestBody RoleGroupSaveVO saveVO) {
        return service.upsert(saveVO);
    }

    /**
     * 删除角色组
     *
     * @param id 角色组ID
     * @return 删除结果
     */
    @DeleteMapping(value = "/delete")
    @ApiOperation(value = "删除角色组")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "角色组ID", required = true, dataType = "int")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE, operationDescription = "删除角色组"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Long> delete(@RequestParam(value = "id") @NotNull(message = "角色组ID为空") Long id) {
        return service.delete(id);
    }

    /**
     * 修改启用状态
     *
     * @param id      角色组ID
     * @param enabled 启用状态
     * @return 角色组ID
     */
    @PatchMapping(value = "/update/enabled")
    @ApiOperation(value = "修改启用标识")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "角色组ID", required = true, dataType = "int"),
            @ApiImplicitParam(name = "enabled", value = "启用标识", required = true, dataType = "boolean")
    })
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE, operationDescription = "修改启用标识"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Long> updateEnabled(@RequestParam(value = "id") @NotNull(message = "角色组ID为空") Long id,
                                         @RequestParam(value = "enabled") @NotNull(message = "启用标识为空") Boolean enabled) {
        return service.updateEnabled(id, enabled);
    }

    /**
     * 获取角色组详细信息
     *
     * @param id 角色组ID
     * @return 角色组详细信息
     */
    @GetMapping(value = "/get")
    @ApiOperation(value = "获取角色组详细信息")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "id", value = "角色组ID", required = true, dataType = "int")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "获取角色组详细信息"
            , logEnabled = false, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<RoleGroupDetailRespVO> getDetail(@RequestParam(value = "id") @NotNull(message = "角色组ID为空") Long id) {
        return service.getDetail(id);
    }

    /**
     * 分页查询分组信息
     *
     * @param queryVO 查询参数
     * @return 分组列表
     */
    @PostMapping(value = "/page")
    @ApiOperation(value = "分页查询角色组")
    @ApiOperationSupport(order = 5)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询角色组"
            , logEnabled = false, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<PagingVO<RoleGroupPageRespVO>> pageMng(@RequestBody RoleGroupPageQueryVO queryVO) {
        return service.pageMng(queryVO);
    }

    @Autowired
    public void setService(RoleGroupMngService service) {
        this.service = service;
    }
}
