package com.elitescloud.cloudt.system.controller.mng.role;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RolePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleCloneSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleSaveVO;
import com.elitescloud.cloudt.system.service.RoleMngService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 角色管理.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Api(tags = "角色管理")
@RestController
@RequestMapping(value = "/mng/role", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_ROLE)
public class RoleMngController {

    private final RoleMngService roleMngService;

    public RoleMngController(RoleMngService roleMngService) {
        this.roleMngService = roleMngService;
    }

    /**
     * 分页查询角色
     *
     * @param queryVO 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询角色")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询角色"
    )
    public ApiResult<PagingVO<RolePageRespVO>> page(@RequestBody RolePageQueryVO queryVO) {
        return roleMngService.page(queryVO);
    }

    /**
     * 切换启用禁用
     *
     * @param id 角色ID
     * @return 切换结果
     */
    @ApiOperation(value = "切换启用禁用")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "角色ID", required = true, dataType = "int")
    @PatchMapping(value = "/switch/enabled/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE, operationDescription = "切换启用禁用"
            , logEnabled = true, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<Long> switchEnabled(@PathVariable("id") Long id) {
        return roleMngService.updateEnabled(id);
    }

    /**
     * 删除角色
     *
     * @param id 角色ID
     * @return 删除结果
     */
    @ApiOperation(value = "删除角色")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "角色ID", required = true, dataType = "int")
    @DeleteMapping(value = "/del/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE, operationDescription = "删除角色"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Long> delete(@PathVariable("id") Long id) {
        return roleMngService.delete(id);
    }

    /**
     * 获取角色详情
     *
     * @param id 角色ID
     * @return 角色信息
     */
    @ApiOperation(value = "获取角色详情")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "id", value = "角色ID", required = true, dataType = "int")
    @GetMapping(value = "/get/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "获取角色详情"
            , logEnabled = false, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<RoleDetailRespVO> get(@PathVariable("id") Long id) {
        return roleMngService.get(id);
    }

    /**
     * 保存角色
     *
     * @param saveVO 角色信息
     * @return 新增结果
     */
    @ApiOperation(value = "保存角色")
    @ApiOperationSupport(order = 5)
    @PostMapping(value = "/save")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE, operationDescription = "保存角色"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Long> save(@RequestBody @Valid RoleSaveVO saveVO) {
        return roleMngService.save(saveVO);
    }

    /**
     * 复制角色
     *
     * @param saveVO 角色信息
     * @return 新角色ID
     */
    @ApiOperation(value = "复制角色")
    @ApiOperationSupport(order = 6)
    @PostMapping(value = "/clone")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE, operationDescription = "复制角色"
            , logEnabled = true, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<Long> clone(@RequestBody @Valid RoleCloneSaveVO saveVO) {
        return roleMngService.saveClone(saveVO);
    }
}
