package com.elitescloud.cloudt.system.controller.mng.test;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
@Component
public class TestExportService implements DataExport<TestData, TestQuery> {

    @Override
    public String getTmplCode() {
        return "system_test_export";
    }

    @Override
    public PagingVO<TestData> executeExport(TestQuery queryParam) {
//        List<TestData> list = new ArrayList<>();
//        list.add(new TestData("张三", "1001"));
//        list.add(new TestData("李四", "1002"));
//        list.add(new TestData("王五", "1003"));
//        list.add(new TestData("赵六", "1004"));
//        list.add(new TestData("钱七", "1005"));
//        list.add(new TestData("孙八", "1006"));
//        list.add(new TestData("六九", "1007"));
//        return PagingVO.<TestData>builder().records(list).total(list.size()).build();

//        if (page == 1) {
//            List<TestData> list = new ArrayList<>();
//            list.add(new TestData("张三", "1001"));
//            list.add(new TestData("李四", "1002"));
//            list.add(new TestData("王五", "1003"));
//            return PagingVO.<TestData>builder().records(list).total(6).build();
//        } else if (page == 2) {
//            List<TestData> list = new ArrayList<>();
//            list.add(new TestData("赵六", "1004"));
//            list.add(new TestData("钱七", "1005"));
//            list.add(new TestData("孙八", "1006"));
//            return PagingVO.<TestData>builder().records(list).total(6).build();
//        }
//        return PagingVO.<TestData>builder().build();

        var page = queryParam.getCurrent() + 1;
        if (page == 1) {
            List<TestData> list = new ArrayList<>();
            list.add(new TestData("张三", "1001"));
            list.add(new TestData("李四", "1002"));
            list.add(new TestData("王五", "1003"));
            return PagingVO.<TestData>builder().records(list).total(7).build();
        } else if (page == 2) {
            List<TestData> list = new ArrayList<>();
            list.add(new TestData("赵六", "1004"));
            list.add(new TestData("钱七", "1005"));
            list.add(new TestData("孙八", "1006"));
            return PagingVO.<TestData>builder().records(list).total(7).build();
        } else if (page == 3) {
            List<TestData> list = new ArrayList<>();
            list.add(new TestData("六九", "1007"));
            return PagingVO.<TestData>builder().records(list).total(7).build();
        }
        return PagingVO.<TestData>builder().build();
    }

    @Override
    public Integer pageSize() {
        return 3;
    }
}
