package com.elitescloud.cloudt.system.controller.mng.version;


import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.version.SysVersionPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.version.SysVersionRespVO;
import com.elitescloud.cloudt.system.model.vo.save.version.SysVersionChangeStatusVO;
import com.elitescloud.cloudt.system.model.vo.save.version.SysVersionSaveVO;
import com.elitescloud.cloudt.system.service.SysVersionService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "版本控制")
@RestController
@RequestMapping(value = "/mng/version", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_VERSION)
public class SysVersionController {

    @Autowired
    private SysVersionService sysVersionService;


    @ApiOperation(value = "保存")
    @ApiOperationSupport(order = 1)
    @PostMapping("/save")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE, operationDescription = "保存/修改"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Object> save(@RequestBody SysVersionSaveVO save) {
        return sysVersionService.save(save);
    }

    @ApiOperation(value = "分页查询")
    @ApiOperationSupport(order = 2)
    @PostMapping("/page")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询"
            , logEnabled = false, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<PagingVO<SysVersionRespVO>> page(@RequestBody SysVersionPageQueryVO query) {
        PagingVO<SysVersionRespVO> page = sysVersionService.page(query);
        return ApiResult.ok(page);
    }


    @ApiOperation(value = "删除")
    @ApiOperationSupport(order = 3)
    @DeleteMapping("/del/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE, operationDescription = "删除"
            , logEnabled = true, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<Object> del(@PathVariable Long id) {
        sysVersionService.del(id);
        return ApiResult.ok();
    }


    @ApiOperation(value = "修改状态")
    @ApiOperationSupport(order = 4)
    @PostMapping("/changeStatus")
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE, operationDescription = "修改状态"
            , logEnabled = true, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<Object> changeStatus(@RequestBody SysVersionChangeStatusVO status) {
        sysVersionService.changeStatus(status);
        return ApiResult.ok();
    }

    @ApiOperation(value = "查询启用")
    @ApiOperationSupport(order = 5)
    @GetMapping("/getActiveVersion")
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE, operationDescription = "查询启用"
            , logEnabled = false, resultJsonEnabled = false, argsJsonEnabled = false)
    public ApiResult<SysVersionRespVO> getActiveVersion() {
        return sysVersionService.getCurrentVersionDetail();
    }


}
