package com.elitescloud.cloudt.system.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.model.vo.resp.index.CurrentEmployeeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeOrgInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeOrgInfoSaveVO;
import com.elitescloud.cloudt.system.provider.export.param.ExportEmployeeBO;
import com.elitescloud.cloudt.system.provider.imports.param.ImportEmployeeBO;
import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/8
 */
@Mapper(config = BaseMapperConfig.class)
public interface EmployeeConvert {
    EmployeeConvert INSTANCE = Mappers.getMapper(EmployeeConvert.class);

    SysEmployeeDO saveVO2DO(EmployeeOrgInfoSaveVO saveVO);

    SysEmployeeDO saveBO2Do(SysEmployeeSaveBO saveVO);

    void saveBO2DO(SysEmployeeSaveBO saveBO, @MappingTarget SysEmployeeDO employeeDO);

    SysEmployeeSaveBO saveVO2BO(EmployeeOrgInfoSaveVO saveVO);

    SysEmployeeSaveBO saveDto2BO(EmployeeUpsertDTO upsertDTO);

    SysEmployeeSaveBO do2SaveBO(SysEmployeeDO employeeDO);

    SysEmployeeSaveBO copy2SaveBO(EmployeeOrgInfoSaveVO saveVO, @MappingTarget SysEmployeeSaveBO saveBO);

    SysEmployeeSaveBO copy2SaveBO(EmployeeUpsertDTO upsertDTO, @MappingTarget SysEmployeeSaveBO saveBO);

    EmployeeOrgInfoRespVO do2RespVO(SysEmployeeDO employeeDO);

    SysEmployeeBasicDTO do2BasicDto(SysEmployeeDO employeeDO);

    SysEmployeeDetailDTO do2DetailDto(SysEmployeeDO employeeDO);

    EmployeeUnderlingDTO do2UnderlingDto(SysEmployeeDO employeeDO);

    ExportEmployeeBO pageRespVo2ExportBO(EmployeePagedRespVO respVO);

    SysEmployeeSaveBO importBo2SaveBo(ImportEmployeeBO employeeBO);

    SysUserSaveBO importBo2UserSaveBo(ImportEmployeeBO employeeBO);

    SysUserSaveBO upsertDTO2UserSaveBo(EmployeeUpsertDTO upsertDTO);

    SysUserSaveBO copyUpserDTO2UserSaveBO(EmployeeUpsertDTO upsertDTO, @MappingTarget SysUserSaveBO saveBO);

    CurrentEmployeeRespVO do2CurrentRespVO(SysEmployeeDO employeeDO);
}
