package com.elitescloud.cloudt.system.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.model.vo.query.message.MsgTemplateVO;
import com.elitescloud.cloudt.system.model.vo.save.message.MsgTemplateSaveParam;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * @author Mir
 */
@Mapper(config = BaseMapperConfig.class)
public interface MsgTemplateConvert {

    MsgTemplateConvert INSTANCE = Mappers.getMapper(MsgTemplateConvert.class);

    MsgTemplateVO doToVO(SysMsgTemplateDO templateDO);

    SysMsgTemplateDO voToDO(MsgTemplateVO templateVO);

    /**
     * 新增参数转换为 do
     *
     * @param param 新增参数
     * @return do
     */
    SysMsgTemplateDO saveParamToDo(MsgTemplateSaveParam param);

    /**
     * 保存参数 更新数据到 do
     *
     * @param param         保存参数
     * @param msgTemplateDO do
     */
    @Mapping(target = "id", ignore = true)
    void updateDoFromSaveParam(MsgTemplateSaveParam param, @MappingTarget SysMsgTemplateDO msgTemplateDO);
}
