package com.elitescloud.cloudt.system.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgDetailRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgSaveVO;
import com.elitescloud.cloudt.system.service.model.bo.SysOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 组织相关POJO转换.
 *
 * @author Kaiser（wang shao）
 * 2022/9/29
 */
@Mapper(config = BaseMapperConfig.class)
public interface OrgConvert {

    OrgConvert INSTANCE = Mappers.getMapper(OrgConvert.class);

    SysOrgSaveBO saveVo2SaveBo(OrgSaveVO saveVO);

    SysOrgSaveBO upsertDTO2SaveBo(OrgUpsertDTO upsertDTO);

    SysOrgSaveBO do2SaveBo(SysOrgDO orgDO);

    OrgPagedRespVO do2PageRespVO(SysOrgDO orgDO);

    SysOrgPageRespDTO do2PageRespDTO(SysOrgDO orgDO);

    SysOrgDO saveBo2Do(SysOrgSaveBO saveBO);

    void copySaveVo2Bo(OrgSaveVO saveVO, @MappingTarget SysOrgSaveBO saveBO);

    void copyUpsertDTO2Bo(OrgUpsertDTO upsertDTO, @MappingTarget SysOrgSaveBO saveBO);

    void copySaveBo2Do(SysOrgSaveBO saveBO, @MappingTarget SysOrgDO orgDO);

    OrgTreeNodeRespVO do2TreeNodeRespVO(SysOrgDO orgDO);

    OrgDetailRespVO do2DetailRespVO(SysOrgDO orgDO);

    SysOrgDetailRespDTO do2DetailRespDTO(SysOrgDO orgDO);

    OrgPagedRespVO do2MngPageRespVO(SysOrgDO orgDO);
}
