package com.elitescloud.cloudt.system.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageMngRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageQueryRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TmplSaveVO;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/31
 */
@Mapper(config = BaseMapperConfig.class)
public interface TmplConvert {

    TmplConvert INSTANCE = Mappers.getMapper(TmplConvert.class);

    /**
     * do转vo list
     *
     * @param doList do list
     * @return vo list
     */
    List<TmplPageMngRespVO> do2VoList(List<SysTmplDO> doList);

    TmplPageMngRespVO do2PageVo(SysTmplDO doList);

    TmplPageQueryRespVO do2PageQueryVo(SysTmplDO doList);

    /**
     * do转vo
     *
     * @param doo do
     * @return vo
     */
    TmplEditRespVO do2Vo(SysTmplDO doo);

    /**
     * vo转do
     *
     * @param vo vo
     * @return do
     */
    SysTmplDO vo2Do(TmplSaveVO vo);

    /**
     * do转dto
     *
     * @param doo do
     * @return dto
     */
    SysTmplDTO vo2Dto(SysTmplDO doo);
}
