package com.elitescloud.cloudt.system.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.system.model.bo.SysUdcBO;
import com.elitescloud.cloudt.system.model.bo.SysUdcValueBO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcValueRespVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcValueSaveVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * UDC相关POJO转换.
 *
 * @author Kaiser（wang shao）
 * 2022/10/11
 */
@Mapper(config = BaseMapperConfig.class)
public interface UdcConvert {

    UdcConvert INSTANCE = Mappers.getMapper(UdcConvert.class);

    UdcPageRespVO do2PageRespVO(SysPlatformUdcDO udcDO);

    UdcDetailRespVO do2DetailRespVO(SysPlatformUdcDO udcDO);

    List<UdcValueRespVO> valueDo2RespVoList(List<SysPlatformUdcValueDO> valueDOS);

    void copyUdcValue(UdcValueSaveVO saveVO, @MappingTarget SysPlatformUdcValueDO valueDO);

    SysPlatformUdcValueDO valueSaveVo2DO(UdcValueSaveVO saveVO);

    @Mapping(target = "id", ignore = true)
    void copyUdcBO(SysUdcBO udcBO, @MappingTarget SysPlatformUdcDO udcDO);

    @Mapping(target = "id", ignore = true)
    void copyUdcValueBO(SysUdcValueBO valueBO, @MappingTarget SysPlatformUdcValueDO valueDO);
}
