package com.elitescloud.cloudt.system.convert;

import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserQueryRespVO;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import com.elitescloud.cloudt.system.service.model.bo.AreaBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

/**
 * 用户相关pojo转换
 *
 * @author Kaiser（wang shao）
 * 2020/6/16
 */
@Mapper(config = BaseMapperConfig.class)
public interface UserConvert {

    UserConvert INSTANCE = Mappers.getMapper(UserConvert.class);

    UserPageRespVO doToPageRespVo(SysUserDO user);

    UserQueryRespVO doToQueryRespVo(SysUserDO user);

    UserDetailRespVO doToDetailRespVo(SysUserDO userDO);

    SysUserSaveBO vo2SaveBo(UserSaveVO saveVO);

    void copy2SaveBo(UserSaveVO saveVO, @MappingTarget SysUserSaveBO saveBO);

    SysUserSaveBO do2SaveBo(SysUserDO userDO);

    SysUserBasicDTO do2Basic(SysUserDO userDO);

    SysUserSaveBO dto2SaveBo(UserCreateDTO saveVO);

    SysUserDO saveBo2Do(SysUserSaveBO saveBO, AreaBO areaBO);

    @Mappings({
            @Mapping(target = "id", ignore = true)
    })
    void copySaveBo2Do(SysUserSaveBO saveBO, AreaBO areaBO, @MappingTarget SysUserDO userDO);

    AuthUserDTO do2AuthUserDTO(SysUserDO userDO);
}
