package com.elitescloud.cloudt.system.convert.old;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * <pre>
 * 系统用户在DO和VO之间拷贝转型
 * </pre>
 *
 * @author Michael Li
 * 2020/6/16
 */
@Mapper(config = BaseMapperConfig.class)
public interface SysUserConvert {

    SysUserConvert INSTANCE = Mappers.getMapper(SysUserConvert.class);

    /**
     * 转换UserDO到VO，并脱敏移除密码和角色清单
     *
     * @param user UserDO对象
     * @return UserVO对象
     */
    SysUserVO doToVo(SysUserDO user);

    /**
     * 新增参数转换为 do
     *
     * @param param 新增参数
     * @return do
     */
    SysUserDO newToDo(SysUserNewParam param);

    /**
     * 用户更新参数更新到 do
     *
     * @param param     新增参数
     * @param sysUserDO do
     */
    @Mapping(target = "id", ignore = true)
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void updateToDo(SysUserUpdateParam param, @MappingTarget SysUserDO sysUserDO);

    SysUserDTO doToDto(SysUserDO user);
}
