package com.elitescloud.cloudt.system.factory.seq;

import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.bo.SysSeqRuleDtlBO;
import com.elitescloud.cloudt.system.service.repo.SeqNextNumRepoProc;
import com.elitescloud.cloudt.system.service.repo.SeqRuleDtlRepoProc;
import com.elitescloud.cloudt.system.service.repo.SeqRuleRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/24/2023
 */
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg = false)
@Service
class SeqNumSupportService {

    @Autowired
    private SeqNextNumRepoProc nextNumRepoProc;
    @Autowired
    private SeqRuleDtlRepoProc ruleDtlRepoProc;
    @Autowired
    private SeqRuleRepoProc ruleRepoProc;

    /**
     * 根据发号规则编码获取ID
     *
     * @param appCode  应用编码
     * @param ruleCode 发号规则编码
     * @return 规则ID
     */
    Long getRuleIdByCode(@NotBlank String appCode, @NotBlank String ruleCode) {
        return ruleRepoProc.getIdByRuleCode(appCode, ruleCode);
    }

    /**
     * 根据下一编号的编码获取ID
     *
     * @param appCode 应用编码
     * @param nnCode  下一编号的编码
     * @return 下一编号ID
     */
    Long getNextNumberIdByCode(@NotBlank String appCode, @NotBlank String nnCode) {
        return nextNumRepoProc.getIdByCode(appCode, nnCode);
    }

    /**
     * 根据发号规则ID获取发号规则明细
     *
     * @param ruleId 发号规则ID
     * @return 发号规则明细
     */
    List<SysSeqRuleDtlBO> getRuleDetailsByRuleId(long ruleId) {
        return ruleDtlRepoProc.queryBoByRuleId(ruleId);
    }
}
