package com.elitescloud.cloudt.system.model.bo;

import cn.hutool.core.text.CharSequenceUtil;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 员工组织.
 *
 * @author Kaiser（wang shao）
 * @date 2/28/2023
 */
@Data
public class EmployeeOrgBO implements Serializable {
    private static final long serialVersionUID = -5188147252322623172L;

    /**
     * 当前员工ID
     */
    private Long ownerId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 员工编号
     */
    private String employeeCode;
    /**
     * 员工类型
     */
    private String employeeType;
    /**
     * 登录号
     */
    private String username;

    /**
     * 名字
     */
    private String firstName;

    /**
     * 姓氏
     */
    private String lastName;

    /**
     * 组织ID
     */
    private Long orgId;

    /**
     * 组织编码
     */
    private String orgCode;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 获取全名
     *
     * @return 全名
     */
    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }
}
