package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.platform.model.constant.PlatformMenusOuterLinkTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 平台擦地.
 *
 * @author Kaiser（wang shao）
 * 2022/10/21
 */
@Data
public class MenuBO implements Serializable {
    private static final long serialVersionUID = -8818063302958986453L;

    /**
     * ID
     */
    private Long id;

    /**
     * 所属应用
     */
    private String menusAppCode;

    /**
     * 菜单名称
     */
    private String menusName;

    /**
     * 菜单类型
     */
    private String menusType;

    /**
     * 节点类型 菜单,按钮
     */
    private String nodeType;

    /**
     * 菜单编码
     */
    private String menusCode;

    /**
     * 排序
     */
    private Integer menusOrder;

    /**
     * 启用状态
     */
    private Boolean menusState;

    /**
     * 上级菜单编码
     */
    private String menusParentCode;

    /**
     * 菜单路由
     */
    private String menusRoute;

    /**
     * 图标
     */
    private String menusIcon;

    /**
     * 是否展示
     */
    private Boolean display;

    /**
     * 是否外链接
     */
    private Boolean outerLink;

    /**
     * 外链接类型
     */
    private PlatformMenusOuterLinkTypeEnum outerLinkType;
}
