package com.elitescloud.cloudt.system.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 发号规则.
 *
 * @author Kaiser（wang shao）
 * 2022/11/14
 */
@Data
public class SysSeqRuleBO implements Serializable {
    private static final long serialVersionUID = 2996775823044657427L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 应用编号
     */
    private String appCode;

    /**
     * 规则编号
     */
    private String ruleCode;

    /**
     * 规则名称
     */
    private String ruleName;

    /**
     * 取号示例
     */
    private String sampleCode;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否开启了租户自定义
     */
    private Boolean tenantCustom;

    /**
     * 规则明细
     */
    private List<SysSeqRuleDtlBO> ruleDtlList;

    /**
     * 下一编号
     */
    private List<SysSeqNextNumberBO> nextNumberList;
}
