package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * MQ消息消费记录.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
@Entity
@Table(name = "sys_mq_consume", indexes = {
        @Index(name = "idx_mq_con_msgid", columnList = "messageId"),
        @Index(name = "idx_mq_con_recod", columnList = "recordId"),
})
@Comment("MQ消息消费记录")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysMqConsumeDO extends BaseModel {
    private static final long serialVersionUID = -4674644363894126422L;

    /**
     * 消息ID
     */
    @Comment("消息ID")
    @Column()
    private String messageId;

    /**
     * 消息记录ID
     */
    @Comment("消息记录ID")
    @Column()
    private Long recordId;

    /**
     * 应用编码
     */
    @Comment("应用编码")
    @Column()
    private String appCode;

    /**
     * 消费者名称
     */
    @Comment("消费者名称")
    @Column()
    private String consumerName;

    /**
     * 消费者IP
     */
    @Comment(value = "消费者IP")
    @Column()
    private String consumerIp;

    /**
     * 消费时间
     */
    @Comment("消费时间")
    @Column()
    private LocalDateTime consumeTime;

    /**
     * 是否消费成功
     */
    @Comment(value = "是否消费成功", defaultValue = "0")
    @Column()
    private Boolean success;

    /**
     * 消费失败原因
     */
    @Comment("消费失败原因")
    @Column()
    @Lob
    private String failReason;

    /**
     * 原始消息ID
     */
    @Comment(value = "原始消息ID")
    @Column()
    private String originalMessageId;

    /**
     * 消费耗时，单位毫秒
     */
    @Comment(value = "消费耗时，单位毫秒")
    @Column()
    private Long costTime;
}
