package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * MQ消息发送记录.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
@Entity
@Table(name = "sys_mq_message", indexes = {
        @Index(name = "idx_mq_msg_msgid", columnList = "messageId"),
        @Index(name = "idx_mq_msg_tenantid", columnList = "sysTenantId"),
        @Index(name = "idx_mq_msg_appcode", columnList = "appCode"),
        @Index(name = "idx_mq_msg_channel", columnList = "channel"),
        @Index(name = "idx_mq_msg_key", columnList = "businessKey"),
        @Index(name = "idx_mq_msg_sendtime", columnList = "sendTime"),
        @Index(name = "idx_mq_msg_success", columnList = "success"),
})
@Comment("MQ消息发送记录")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysMqMessageDO extends BaseModel {
    private static final long serialVersionUID = -4674644363894126422L;

    /**
     * 消息ID
     */
    @Comment("消息ID")
    @Column()
    private String messageId;

    /**
     * 所属租户ID
     */
    @Comment("租户ID")
    @Column()
    private Long sysTenantId;

    /**
     * 应用编码
     */
    @Comment("应用编码")
    @Column()
    private String appCode;

    /**
     * 渠道编码
     */
    @Comment("渠道编码")
    @Column(nullable = false)
    private String channel;

    /**
     * 消息内容
     */
    @Comment("消息内容")
    @Column()
    @Lob
    private String messageContent;

    /**
     * 业务数据key
     */
    @Column()
    @Comment(value = "业务数据key")
    private String businessKey;

    /**
     * 发送时间
     */
    @Comment("发送时间")
    @Column()
    private LocalDateTime sendTime;

    /**
     * 发送结束时间
     */
    @Comment("发送结束时间")
    @Column()
    private LocalDateTime finishTime;

    /**
     * 是否本地化消费
     */
    @Comment("是否本地化消费")
    @Column()
    private Boolean local;

    /**
     * 是否发送成功
     */
    @Comment(value = "是否发送成功", defaultValue = "0")
    @Column()
    private Boolean success;

    /**
     * 发送失败原因
     */
    @Comment("发送失败原因")
    @Column()
    @Lob
    private String failReason;

    /**
     * 发送重试的次数
     */
    @Comment(value = "发送重试的次数", defaultValue = "0")
    @Column()
    private Integer retryTimes;

    /**
     * 消息类型
     */
    @Comment(value = "是否是重试消息", defaultValue = "0")
    @Column()
    private Boolean retried;

    /**
     * 最后一次重试的消息ID
     */
    @Comment(value = "最后一次重试的消息ID")
    @Column()
    private String lastRetryMessageId;

    /**
     * 重试失败原因
     */
    @Comment(value = "重试失败原因")
    @Column()
    private String retryFailReason;

    /**
     * 原始消息ID
     */
    @Comment(value = "原始消息ID")
    @Column()
    private String originalMessageId;

    /**
     * 是否已消费
     */
    @Comment(value = "是否已消费", defaultValue = "0")
    @Column()
    private Boolean consumed;

    /**
     * 消费时间
     */
    @Comment("消费时间")
    @Column()
    private LocalDateTime consumeTime;
}
