package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 资源表.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/25
 */
@Entity
@Table(name = "sys_resource_byte", indexes = {
        @Index(name = "idx_res_byte_restype", columnList = "resourceType"),
        @Index(name = "idx_res_byte_reskey", columnList = "resourceKey"),
        @Index(name = "idx_res_byte_temp", columnList = "temp"),
})
@Comment("资源表")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysResourceByteDO extends BaseStdModel {
    private static final long serialVersionUID = -6250665266675808750L;

    @Comment("资源类型")
    @Column(nullable = false)
    private String resourceType;

    @Comment("资源唯一标识")
    @Column(nullable = false)
    private String resourceKey;

    @Comment("资源")
    @Column(nullable = false)
    @Lob
    private byte[] resource;

    @Comment("文件mime-type")
    @Column()
    private String mimeType;

    @Comment("扩展名")
    @Column()
    private String suffix;

    @Comment("原始名称")
    @Column()
    private String resourceName;

    @Comment("显示名称")
    @Column()
    private String showName;

    @Comment("文件大小")
    @Column()
    private Long size;

    @Comment(value = "是否是临时文件", defaultValue = "1")
    @Column()
    private Boolean temp;
}
