package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <pre>
 *     系统配置表
 * </pre>
 *
 * @author Michael Li
 * 2020-06-15
 */
@Entity
@Table(name = "sys_setting", indexes = {
        @Index(name = "idx_setting_settingNo", columnList = "settingNo")
})
@org.hibernate.annotations.Table(appliesTo = "sys_setting", comment = "系统配置表")
@Data
@Accessors(chain = true)
@ApiModel(value = "系统配置表", description = "系统配置表")
@DynamicUpdate
public class SysSettingDO extends BaseStdModel {

    private static final long serialVersionUID = -7840804475330315230L;

    @Comment("设置的编号")
    @Column(nullable = false)
    private String settingNo;

    @Comment("设置名称")
    @Column()
    private String settingName;

    @Comment("设置类型")
    @Column()
    private String settingType;

    @Comment("设置类型2")
    @Column()
    private String settingType2;

    @Comment("设置类型3")
    @Column()
    private String email;

    @Comment("设置状态")
    @Column()
    private String settingStatus;

    @Comment("设置描述")
    @Column(length = 500)
    private String settingDesc;

    @Comment("设置值")
    @Column(length = 500)
    private String settingVal;

    @Comment("默认值")
    @Column(name = "def_val", length = 500)
    private String defaultValue;

    @Comment("排序号")
    @Column()
    private Integer sortNo;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysSettingDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysSettingDO entity = (SysSettingDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}