package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.http.HttpMethod;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 三方接口调用日志.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
@Entity
@Table(name = "sys_third_api_log", indexes = {
        @Index(name = "idx_thirdapi_log_tenant", columnList = "sysTenantId"),
        @Index(name = "idx_thirdapi_log_app", columnList = "appCode"),
        @Index(name = "idx_thirdapi_log_third", columnList = "thirdApp"),
        @Index(name = "idx_thirdapi_log_uri", columnList = "uri"),
        @Index(name = "idx_thirdapi_log_bustype", columnList = "businessType"),
        @Index(name = "idx_thirdapi_log_buskey", columnList = "businessKey"),
        @Index(name = "idx_thirdapi_log_reqsuc", columnList = "reqSuccess"),
        @Index(name = "idx_thirdapi_log_respsuc", columnList = "respSuccess"),
})
@Comment("三方接口调用日志")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysThirdApiLogDO extends BaseModel {
    private static final long serialVersionUID = 1230998193088176738L;

    @Column()
    @Comment(value = "租户ID")
    private Long sysTenantId;

    /**
     * 请求业务域编码
     */
    @Column()
    @Comment(value = "应用编码")
    private String appCode;

    /**
     * 是否是Restful接口
     */
    @Column()
    @Comment(value = "是否是Restful接口", defaultValue = "1")
    private Boolean restful;

    /**
     * 当前是否是服务端
     */
    @Column()
    @Comment(value = "当前是否是服务端", defaultValue = "0")
    private Boolean server;

    /**
     * 服务端地址
     * <p>
     * 如果 {@link #server} = false，则 {@link #serverAddr} 不能为空
     */
    @Column()
    @Comment(value = "服务端地址，当不是服务端时，不能为空")
    private String serverAddr;

    /**
     * 外部应用名称
     */
    @Column()
    @Comment(value = "外部应用名称，作为客户端时，不能为空")
    private String thirdApp;

    /**
     * 业务类型
     */
    @Column()
    @Comment(value = "业务类型")
    private String businessType;

    /**
     * 业务数据key
     */
    @Column()
    @Comment(value = "业务数据key")
    private String businessKey;

    /**
     * 客户端ID
     */
    @Column()
    @Comment(value = "客户端ID")
    private String clientId;

    /**
     * 请求用户ID
     */
    @Column()
    @Comment(value = "请求用户ID")
    private Long userId;

    /**
     * 请求用户
     */
    @Column()
    @Comment(value = "请求用户")
    private String username;

    /**
     * 请求的接口地址
     */
    @Column()
    @Comment(value = "请求的接口地址")
    private String uri;

    /**
     * 请求方式
     */
    @Column()
    @Comment(value = "请求方式")
    @Enumerated(value = EnumType.STRING)
    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    @Column()
    @Comment(value = "请求的查询参数")
    @Lob
    private String reqQueryParamsJson;

    /**
     * 请求体
     */
    @Column()
    @Comment(value = "请求体")
    @Lob
    private String reqBody;

    /**
     * 请求头
     */
    @Column()
    @Comment(value = "请求头")
    @Lob
    private String reqHeadersJson;

    /**
     * 是否请求成功
     */
    @Column()
    @Comment(value = "是否请求成功", defaultValue = "0")
    private Boolean reqSuccess;

    /**
     * 请求失败信息
     */
    @Column()
    @Comment(value = "请求失败信息")
    @Lob
    private String reqFailMsg;

    /**
     * 请求时间
     */
    @Column(nullable = false)
    @Comment(value = "请求时间")
    private LocalDateTime reqTime;

    /**
     * 请求者IP
     */
    @Column()
    @Comment(value = "请求者IP")
    private String reqIp;

    /**
     * 响应体
     */
    @Column()
    @Comment(value = "响应体")
    @Lob
    private String respBody;

    /**
     * 是否响应成功
     */
    @Column()
    @Comment(value = "是否响应成功", defaultValue = "0")
    private Boolean respSuccess;

    /**
     * 响应失败信息
     */
    @Column()
    @Comment(value = "响应失败信息")
    @Lob
    private String respFailMsg;

    /**
     * 响应时间
     */
    @Column()
    @Comment(value = "响应时间")
    private LocalDateTime respTime;

    /**
     * 是否需要重试
     */
    @Column()
    @Comment(value = "是否需要重试", defaultValue = "0")
    private Boolean needRetry;

    /**
     * 自动获取操作人的token
     */
    @Column()
    @Comment(value = "自动获取操作人的token", defaultValue = "0")
    private Boolean detectedOperatorAuth;

    /**
     * 重试参数
     */
    @Column()
    @Comment(value = "重试参数")
    @Lob
    private String retryParamJson;

    /**
     * 重试次数
     */
    @Column()
    @Comment(value = "重试次数", defaultValue = "0")
    private Integer retryTimes;

    /**
     * 重试失败原因
     */
    @Column()
    @Comment(value = "重试失败原因")
    @Lob
    private String retryFailReason;

    /**
     * 是否是重试记录
     */
    @Comment(value = "是否是重试记录", defaultValue = "0")
    @Column()
    private Boolean retried;

    /**
     * 是否是手动重试
     */
    @Comment(value = "是否是手动重试", defaultValue = "0")
    @Column()
    private Boolean manualRetry;

    /**
     * 原始记录ID
     */
    @Column()
    @Comment(value = "原始记录ID")
    private Long originalId;

    /**
     * 最后一次重试的ID
     */
    @Comment(value = "最后一次重试的ID")
    @Column()
    private Long lastRetryId;
}
