package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 *    系统水印配置
 * </p>
 *
 * @author roman
 * @since 2022/3/25 10:00 AM
 */
@Entity
@Table(name = "sys_watermark_config")
@org.hibernate.annotations.Table(appliesTo = "sys_watermark_config", comment = "系统水印配置")
@Data
@Accessors(chain = true)
@ApiModel(value = "系统水印配置", description = "系统水印配置")
@DynamicUpdate
public class SysWatermarkConfigDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1810327133954924856L;

    @ApiModelProperty(value = "动态文字")
    @Comment("动态文字")
    @Column()
    private String dynamicFont;

    @ApiModelProperty(value = "自定义文字")
    @Comment("自定义文字")
    private String customField;

    @ApiModelProperty(value = "文字大小")
    @Comment("文字大小")
    private Integer fontSize;

    @ApiModelProperty(value = "颜色深浅")
    @Comment("颜色深浅")
    private String fontColor;

    @ApiModelProperty(value = "旋转角度")
    @Comment("旋转角度")
    private Integer rotate;

    @ApiModelProperty(value = "层叠深度")
    @Comment("层叠深度")
    private Integer stackingDeep;
}
