package com.elitescloud.cloudt.system.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 接口重试次数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/20
 */
@Data
@ApiModel(description = "重试参数")
public class ThirdApiRetryVO implements Serializable {
    private static final long serialVersionUID = -8734981370657618562L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 服务端地址
     * <p>
     * 为空则取当前服务的地址（不包含路由）
     */
    @ApiModelProperty(value = "服务端地址", position = 2)
    private String serverAddr;

    /**
     * 请求的接口地址
     * <p>
     * 包含路由
     */
    @ApiModelProperty(value = "请求的接口地址", position = 3)
    @NotBlank(message = "接口地址为空")
    private String uri;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式", position = 4)
    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    private Map<String, String[]> reqQueryParams;

    /**
     * 请求体
     */
    private String reqBody;

    /**
     * 请求头
     */
    private Map<String, String[]> reqHeaders;
}
