package com.elitescloud.cloudt.system.model.vo.query.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 行政区域查询参数.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "行政区域查询参数")
public class CommonAreaQueryVO implements Serializable {
    private static final long serialVersionUID = -2235395335949750066L;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID", position = 1)
    private Long pid;

    /**
     * 上级编码
     */
    @ApiModelProperty(value = "上级编码", position = 2)
    private String pcode;

    /**
     * 类型，[UDC]cloudt-system:areaType
     */
    @ApiModelProperty(value = "类型，[UDC]cloudt-system:areaType", position = 3)
    private String areaType;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称", position = 11)
    private String name;
}
