package com.elitescloud.cloudt.system.model.vo.query.extend;

import com.el.coordinator.core.common.jpa.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 模板查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/28
 */
@Data
@ApiModel(description = "模板查询参数")
public class TmplQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -3334213833453058874L;

    @ApiModelProperty(value = "应用编码", required = true)
    @NotBlank(message = "应用编码不能为空")
    private String appCode;

    @ApiModelProperty(value = "模板编码")
    private String tmplCode;

    @ApiModelProperty(value = "是否是导出模板")
    private Boolean export;
}
