package com.elitescloud.cloudt.system.model.vo.query.message;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author Mir
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "消息模板", description = "消息模板")
public class MsgTemplateVO implements Serializable {
    private static final long serialVersionUID = 472042967400121694L;

    @ApiModelProperty(value = "id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("模版编号")
    private String code;

    @ApiModelProperty(value = "主题")
    private String subject;

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "纯文本内容")
    private String textContent;

    @ApiModelProperty(value = "富文本内容")
    private String richContent;
}