package com.elitescloud.cloudt.system.model.vo.query.org;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 分页查询员工组的员工.
 *
 * @author Kaiser（wang shao）
 * 2023/1/16
 */
@Data
@ApiModel(description = "分页查询员工组的员工")
public class EmpGroupEmpPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -4317825782321012247L;

    /**
     * 员工组ID
     */
    @ApiModelProperty(value = "员工组ID", position = 1, required = true)
    @NotNull(message = "员工组ID为空")
    private Long groupId;

    /**
     * 员工编码
     */
    @ApiModelProperty(value = "员工编码", position = 2)
    private String employeeCode;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名", position = 3)
    private String empName;
}
