package com.elitescloud.cloudt.system.model.vo.query.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 员工列表查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/19
 */
@Data
@ApiModel(description = "员工列表查询参数")
public class EmployeeListQueryVO implements Serializable {
    private static final long serialVersionUID = 6783701691521938649L;

    @ApiModelProperty(value = "根据员工编号模糊查询")
    private String codeLike;

    @ApiModelProperty(value = "根据姓名模糊查询")
    private String fullNameLike;

    @ApiModelProperty(value = "根据登录号模糊查询")
    private String usernameLike;

    @ApiModelProperty(value = "根据姓名或登录号模糊查询")
    private String fullNameOrUsernameLike;

    @ApiModelProperty(value = "根据员工编号或姓名或登录号模糊查询")
    private String codeOrFullNameOrUsernameLike;
}
