package com.elitescloud.cloudt.system.model.vo.query.org;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工分页查询信息")
public class EmployeePageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -761229337290141030L;

    /**
     * 组织ID[直属]
     */
    @ApiModelProperty(value = "组织ID[直属]", position = 1)
    private Long orgId;

    /**
     * 组织ID[下属]
     */
    @ApiModelProperty(value = "组织ID[下属]", position = 1)
    private Long orgIdBelong;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 3)
    private String code;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 4)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 5)
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 6)
    private String gender;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话", position = 8)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;

}
