package com.elitescloud.cloudt.system.model.vo.query.role;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 角色分页查询参数.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "角色分页查询参数")
public class RolePageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 4838417825138510585L;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "角色编码", position = 1)
    private String code;

    /**
     * 角色名称
     */
    @ApiModelProperty(value = "角色名称", position = 2)
    private String name;

    /**
     * 业务标识，[UDC]cloudt-system:roleBusiness
     */
    @ApiModelProperty(value = "业务标识，默认系统角色，[UDC]cloudt-system:roleBusiness", position = 3)
    private String businessKey;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 3)
    private Boolean enabled;

    /**
     * 角色分组ID
     */
    @ApiModelProperty(value = "角色分组ID", position = 4)
    private Long groupId;
}
